const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_master19', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrdType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    Nom: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Tol1NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1Neg: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1Pos: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2Neg: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2Pos: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    GraphOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MinValue: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MaxValue: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    AvgValue: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StartDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    FinalMinDT: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    FinalMaxDT: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    FinalAvgDT: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TempRange: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_master19',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_batc__647BBB2967FC5F2C",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
